/*---------------------------------------------------------------------------+
|                                                                            |
| PMSPYOW.C                                                                  |
|                                                                            |
| Dialog procedure to display and select an OBJECT window for SPYing         |
+----------------------------------------------------------------------------+
| History:                                                                   |
| --------                                                                   |
|                                                                            |
| created: dec 12 1989 by Steve Diering                                      |
|                                                                            |
| updated:                                                                   |
|                                                                            |
+---------------------------------------------------------------------------*/

#include "pmspy.h"                      /* Resource symbolic identifiers*/

static HELP_DATA    helpOW        = {                      /* HELP dialog data */
                                      { NULL,
                                        IDT_HELP,
                                        IDT_OW_HELP,       /* HELP resource */
                                      },

                                      IDS_HELP_TITLE_OW    /* Title */
                                    };

#define  SYSTEM_OBJECT_WINDOW_ID '#'    // first char of SYSTEM object class name

typedef struct
{
  HWND       hwnd;
  char       szClass[40];
  PID        pidCreator;
  TID        tidCreator;
  CLASSINFO  classInfo;
  HMQ        hmq;

} OW_INFO, * POW_INFO;

/***************************************************************************
*
* Arg...these are global variables!
*
***************************************************************************/

BOOL   defWantSYSTEM  = FALSE;

 /***************************************************************************************
  *
  * Routine to add one OBJECT window to the LISTBOX
  *
  ***************************************************************************************/
static
void AddOneObjectToList( HWND   hwndList,      // window of LISTBOX
                         USHORT idList,        // id     of LISTBOX
                         HWND   hwndObject,    // window of OBJECT
                         USHORT depth,         // "depth" of hierarchy
                         BOOL   fWantSystem)   // want SYSTEM object windows?

{
  USHORT   list_index;

  OW_INFO  objData;

  POW_INFO pOW;

  char     szDepth[40],
           szData[128];

  PSZ      pszClass;

  memset(&objData, NULL, sizeof(objData) );

  objData.hwnd = hwndObject;

  // generate window depth guage

  if (depth != 0)
    memset(szDepth, '*', depth);

  szDepth[depth] = NULL;

  WinQueryClassName(hwndObject, sizeof(objData.szClass), objData.szClass);

  WinQueryClassInfo(hab, objData.szClass, &objData.classInfo);

  WinQueryWindowProcess(hwndObject, &objData.pidCreator, &objData.tidCreator);

  objData.hmq = (HMQ)WinQueryWindowULong(hwndObject, QWL_HMQ);

  /* if this IS a system class and we don't want'em, ignore it! */

  if ( fWantSystem || (objData.szClass[0] != SYSTEM_OBJECT_WINDOW_ID) )
  {

    pszClass = TranslateClassName( objData.szClass );  // translate SYSTEM

    if ( pszClass != objData.szClass )  // Class name translated?
      sprintf( szData,                  // yes...
               "Class: %s (%s), Hwnd: 0x%lX, Hmq: 0x%lX, Parent: %u/%u",
               objData.szClass,
               pszClass,
               hwndObject,
               objData.hmq,
               objData.pidCreator,
               objData.tidCreator
             );
    else                                // no...
      sprintf( szData,
               "Class: %s, Hwnd: 0x%lX, Hmq: 0x%lX, Parent: %u/%u",
               objData.szClass,
               hwndObject,
               objData.hmq,
               objData.pidCreator,
               objData.tidCreator
             );

    pOW = (POW_INFO) AllocateMemory( sizeof( OW_INFO) );

    *pOW = objData;

    list_index = (USHORT) WinSendDlgItemMsg( /* Send a message to the list   */
                  hwndList,                  /*   Window Handle              */
                  idList,
                  LM_INSERTITEM,             /*   Insert item                */
                  (MPARAM)(fWantSystem
                           ? LIT_SORTDESCENDING //Sort
                           : LIT_SORTASCENDING),
                  (MPARAM) szData);          /*   Text                       */

    WinSendDlgItemMsg(                       /* Send a message to the list   */
                  hwndList,                  /*   Window Handle              */
                  idList,
                  LM_SETITEMHANDLE,          /*   Message                    */
                  (MPARAM)list_index,        /*   Index of list item         */
                  (MPARAM)pOW);              /*   Handle of list item        */
  } /* endif */
}

 /***************************************************************************************
  *
  * Routine to recursively add all OBJECT windows to the LISTBOX
  *
  ***************************************************************************************/
static
void AddObjectChildrenToList(HWND   hwndList,      // window of LISTBOX
                             USHORT idList,        // id     of LISTBOX
                             HWND   hwndObject,    // window of OBJECT
                             USHORT depth,         // "depth" of hierarchy
                             BOOL   fWantSystem)   // want SYSTEM object windows?

{
  HWND     hwndChild;

  HENUM    hEnum = WinBeginEnumWindows( hwndObject );

  // process all child windows of this window

  for( /* Initialize */ hwndChild  = WinGetNextWindow(hEnum);
       /* While      */ hwndChild != NULL;
       /* Iterate    */ hwndChild  = WinGetNextWindow(hEnum) )
  {
     AddOneObjectToList( hwndList,      // window of LISTBOX
                         idList,        // id     of LISTBOX
                         hwndChild,     // window of OBJECT
                         depth,         // "depth" of hierarchy
                         fWantSystem);  // want SYSTEM object windows?

     AddObjectChildrenToList( hwndList,        // window of LISTBOX
                              idList,          // id     of LISTBOX
                              hwndChild,       // window of OBJECT
                              depth + 1,       // "depth" of hierarchy
                              fWantSystem);    // want SYSTEM object windows?

     WinLockWindow(hwndChild, FALSE);        // unLOCK the window
  }

  WinEndEnumWindows( hEnum );
}

 /****************************************************************************
  *
  * Routine to delete all existing OBJECT windows in the listbox
  *
  * - for performance and a visually 'nice' appear, we'll delete ALL
  *   list items at once (after dealing with each's HANDLE data)
  *
  *
  ***************************************************************************/
static
VOID DeleteList(         HWND     hwndDlg,           // handle of DIALOG
                register USHORT   idList)            // ID of listbox in DIALOG

{
           PSZ    pData;              // data for current list item

  register USHORT uItem;              // deletion loop counter

  register USHORT uTotalItems = (USHORT)
                                WinSendDlgItemMsg(hwndDlg,
                                                  idList,
                                                  LM_QUERYITEMCOUNT,
                                                  NULL,NULL);

 /****************************************************************************
  *
  * Delete HANDLE data for every item
  *
  ***************************************************************************/

  for( /* Initialization */  uItem = 0;                // start @ first Item
       /* While          */  uItem < uTotalItems;      // while not all processed
       /* Iterate        */  uItem++)                  // to the next Item
  {
   /************************************************************************
    *
    * Obtain item's "handlized" data and free allocated memory
    *
    ************************************************************************/

    pData = (PSZ) WinSendDlgItemMsg( hwndDlg,
                                     idList,
                                     LM_QUERYITEMHANDLE, // give me HANDLE
                                     (MPARAM)uItem,      // current Item #
                                     NULL);              // Reserved
    if (pData != NULL)
      FreeMemory( pData );
  }

 /************************************************************************
  *
  * Delete ALL item(s) in list at once (quick and more visually pleasing
  * than do one at a time in the above loop)
  *
  ************************************************************************/

  WinSendDlgItemMsg( hwndDlg,
                     idList,
                     LM_DELETEALL,     // Delete ALL Item
                     NULL,             // Reserved
                     NULL);            // Reserved
}

 /****************************************************************************
  *
  * Routine to generate the list of OBJECT windows
  *
  ***************************************************************************/
static
USHORT GenerateList( HWND     hwndDlg,           // handle of DIALOG
                     USHORT   idList,            // ID of listbox in DIALOG
                     BOOL     WantSYSTEM)        // want SYSTEM object windows?

{
  register USHORT uNumberOfWindows;

  /************************************************************
  * First of all, "lock" the ListBox to minimize bad visual
  * effect from the deletion and insertion of the VIEWs...
  ************************************************************/

  WinLockWindowUpdate(HWND_DESKTOP,                      // Desktop
                      WinWindowFromID(hwndDlg,idList));  // Lockee

  // start by erasing any existing OBJECT windows in the listbox

  DeleteList( hwndDlg,       // window of LISTBOX
              idList);       // id     of LISTBOX

  // start with HWND_OBJECT and add all OBJECT windows

  AddOneObjectToList( hwndDlg,       // window of LISTBOX
                      idList,        // id     of LISTBOX
                      HWND_OBJECT,   // window of OBJECT
                      0,             // "depth" of hierarchy
                      WantSYSTEM);   // determine if SYSTEM inc'ed

  AddObjectChildrenToList( hwndDlg,     // window of LISTBOX
                           idList,      // id     of LISTBOX
                           HWND_OBJECT, // parent window
                           1,           // "depth" of hierarchy
                           WantSYSTEM); // determine if SYSTEM inc'ed

  /************************************************************
  * Finally, "unlock" the ListBox so it is only redrawn once
  ************************************************************/
  WinLockWindowUpdate(HWND_DESKTOP,  // Desktop
                      NULL);         // Re-enable ListBox

  uNumberOfWindows = (USHORT)WinSendDlgItemMsg(hwndDlg,
                                               idList,
                                               LM_QUERYITEMCOUNT,
                                               NULL, NULL);

  if ( (!WantSYSTEM) && (uNumberOfWindows == 0) )
  {
    MsgDisplay( hwndDlg,
                swcntrl.szSwtitle,
                "No application OBJECT windows were found!",
                NULL,
                MB_CUACRITICAL | MB_CANCEL
              );
  }

  return( uNumberOfWindows );
}


 /****************************************************************************
  *
  * Routine to perform DIALOG cleanup and dismisall
  *
  ***************************************************************************/
static
VOID DismissDialog(         HWND     hwndDlg,           // handle of DIALOG
                   register USHORT   idList)            // ID of listbox in DIALOG

{

 /****************************************************************************
  *
  * Delete all list items
  *
  ***************************************************************************/

  DeleteList(hwndDlg, idList);

 /************************************************************************
  *
  * Dismiss the dialog
  *
  ************************************************************************/

  WinDismissDlg( hwndDlg, NULL);
}
 /***************************************************************************************
  *
  * Dialog Procedure for displaying list of OBJECT windows
  *
  ***************************************************************************************/

 MRESULT EXPENTRY ObjectDlgProc(          HWND    hwnd,
                                 register USHORT  message,
                                          MPARAM  lParam1,
                                          MPARAM  lParam2 )

{

 /***********************************************************************************
  *
  *                   Local Variables
  *
  ***********************************************************************************/

  MRESULT  retcode = NULL;
  POW_INFO pOW;

 /***************************************************************************************
  *
  *  Process the message
  *
  ***************************************************************************************/

    switch (message)                       /* Switch off of the message ID */
      {

        case WM_COMMAND:

          switch( LOUSHORT( lParam1 ) )
          {

              /**************************************************************************
               *
               *  process the selected OBJECT window
               *
               **************************************************************************/

              case ID_OW_PB_SPYON:

              {
                USHORT        curItem;                 /* current list item */

                if ( (curItem = (USHORT)
                                WinSendDlgItemMsg(      /* Query 1st selection          */
                                  hwnd,                 /*   Dialog handle              */
                                  ID_OW_LIST,           /*   Listbox ID                 */
                                  LM_QUERYSELECTION,    /*   Query ID of selected       */
                                  (MPARAM)LIT_FIRST,
                                  (MPARAM)NULL)) != LIT_NONE )
                {
                  pOW = (POW_INFO)
                         WinSendDlgItemMsg( hwnd,
                                            ID_OW_LIST,
                                            LM_QUERYITEMHANDLE, /*   Message                    */
                                            (MPARAM) curItem,   /*   Item to get handle of      */
                                            (MPARAM) NULL);     /*   Reserved                   */
                 /**************************************************************************
                  *
                  *  Switch to SPYing this OBJECT window...
                  *
                  **************************************************************************/

                  SpySetTarget(SpyInstance, pOW->hwnd, pOW->hmq);

                  bWindowIsObject = TRUE;

                  UpdateSpyTitle(hwndFrame,
                                 SpyQueryTargetIsWindow(SpyInstance)
                                 ? tObject
                                 : tQueue,
                                 SpyQueryTargetIsWindow(SpyInstance)
                                 ? pOW->hwnd
                                 : pOW->hmq);

                 /**************************************************************************
                  *
                  *  End the dialog
                  *
                  **************************************************************************/

                  DismissDialog(hwnd, ID_OW_LIST);     // end the dialog
                }
                else
                  WinAlarm(HWND_DESKTOP, WA_ERROR);
              }
              break;

              /**************************************************************************
               *
               *  process the HELP button
               *
               **************************************************************************/

              case ID_OW_PB_HELP:

                   WinDlgBox(HWND_DESKTOP, hwnd,
                            (PFNWP)HelpWindowProc,
                             NULL, IDD_HELP, (PVOID)&helpOW);

              break;

              /**************************************************************************
               *
               *  refresh the list with all OBJECT windows
               *
               **************************************************************************/

              case ID_OW_PB_REFRESH_ALL:

                   GenerateList(hwnd, ID_OW_LIST, TRUE);

              break;

              /**************************************************************************
               *
               *  refresh the list with only non-system OBJECT windows
               *
               **************************************************************************/

              case ID_OW_PB_REFRESH_PGMR:

                   GenerateList(hwnd, ID_OW_LIST, FALSE);
              break;

              /**************************************************************************
               *
               *  User cancelled exclusion/inclusion
               *
               **************************************************************************/

              case DID_CANCEL:                          /* CANCEL was selected          */

                   DismissDialog(hwnd, ID_OW_LIST);     // end the dialog

              break;                                    /* Break DID_CANCEL             */
            }

          break;                                        /* Break WM_COMMAND             */

        /********************************************************************************/
        /**                                                                            **/
        /** WM_CLOSE:                                                                  **/
        /** - Call WinDismissDlg to close the dialog box                               **/
        /**                                                                            **/
        /********************************************************************************/

        case WM_CLOSE:

             DismissDialog(hwnd, ID_OW_LIST);           // end the dialog

             retcode = (MRESULT)TRUE;

        break;                                                                           /* DB  @P4A */

        /*******************************************************************************
         *
         *  WM_INITDLG:
         *  - Load list with current set of OBJECT windows
         *
         ********************************************************************************/

         case WM_INITDLG:

              GenerateList(hwnd, ID_OW_LIST, defWantSYSTEM);

          break;


        /*******************************************************************************
         *
         *  any other message gets handled in default manner
         *
         ********************************************************************************/

        default:                                        /* Any other message            */
          retcode =  WinDefDlgProc(              /* Return message to default prc*/
                        hwnd,                  /* Dialog Handle                */
                        message,                        /* Message                      */
                        lParam1,                        /* First parameter for message. */
                        lParam2);                       /* Second parameter for message.*/
      }                                                 /* End switch                   */

 /***************************************************************************************
  *
  *                       Exit
  *
  ***************************************************************************************/

   return(retcode);
}
